-- --------------------------------------------------------
-- 主機:                           127.0.0.1
-- 伺服器版本:                        10.5.11-MariaDB-1:10.5.11+maria~focal - mariadb.org binary distribution
-- 伺服器作業系統:                      debian-linux-gnu
-- HeidiSQL 版本:                  11.3.0.6295
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- 傾印  資料表 membercard.activity 結構
DROP TABLE IF EXISTS `activity`;
CREATE TABLE IF NOT EXISTS `activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `actCode` varchar(50) DEFAULT NULL COMMENT '活動代碼',
  `actTitle` varchar(50) DEFAULT NULL COMMENT '活動標題',
  `actSubTitle` varchar(255) DEFAULT NULL COMMENT '活動子標題',
  `actDesc` varchar(255) DEFAULT NULL COMMENT '活動說明',
  `actIsBanner` tinyint(1) DEFAULT NULL COMMENT '是否為輪播圖',
  `actImage` varchar(50) DEFAULT NULL COMMENT '活動小圖',
  `actBigImage` varchar(255) DEFAULT NULL COMMENT '活動大圖',
  `actStartTime` datetime DEFAULT NULL COMMENT '開始時間',
  `actStopTime` datetime DEFAULT NULL COMMENT '結束時間',
  `actStatus` varchar(20) DEFAULT NULL COMMENT '活動狀態',
  `actUrl` varchar(255) DEFAULT NULL COMMENT '相關網址',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `activity_act_code` (`actCode`),
  KEY `storeId` (`storeId`),
  CONSTRAINT `activity_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='活動輪播';

-- 正在傾印表格  membercard.activity 的資料：~4 rows (近似值)
/*!40000 ALTER TABLE `activity` DISABLE KEYS */;
INSERT INTO `activity` (`id`, `actCode`, `actTitle`, `actSubTitle`, `actDesc`, `actIsBanner`, `actImage`, `actBigImage`, `actStartTime`, `actStopTime`, `actStatus`, `actUrl`, `storeId`, `createdAt`, `updatedAt`) VALUES
	(1, '1001', '中秋賞月活動', '中秋賞月活動SUB', '中秋賞月活動說明說明說明', 1, '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', '2021-08-01 00:00:00', '2022-12-31 00:00:00', NULL, NULL, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(2, '1002', '端午肉粽活動', '端午肉粽活動SUB', '端午肉粽活動說明說明說明', 1, '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', '2021-08-01 00:00:00', '2022-12-31 00:00:00', NULL, NULL, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, '2001', '除夕年夜飯活動', '除夕年夜飯活動SUB', '除夕年夜飯活動說明說明說明', 0, '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', '2021-08-01 00:00:00', '2022-12-31 00:00:00', NULL, NULL, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(4, '2002', '新年春聯活動', '新年春聯活動SUB', '新年春聯活動說明說明說明', 0, '00000004.png', '["00000004_b01.png","00000004_b02.png","00000004_b03.png"]', '2021-08-01 00:00:00', '2022-12-31 00:00:00', NULL, NULL, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `activity` ENABLE KEYS */;

-- 傾印  資料表 membercard.act_prod 結構
DROP TABLE IF EXISTS `act_prod`;
CREATE TABLE IF NOT EXISTS `act_prod` (
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  `actId` int(11) NOT NULL,
  `prodId` int(11) NOT NULL,
  PRIMARY KEY (`actId`,`prodId`),
  KEY `prodId` (`prodId`),
  CONSTRAINT `act_prod_ibfk_1` FOREIGN KEY (`actId`) REFERENCES `activity` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `act_prod_ibfk_2` FOREIGN KEY (`prodId`) REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='活動輪播';

-- 正在傾印表格  membercard.act_prod 的資料：~2 rows (近似值)
/*!40000 ALTER TABLE `act_prod` DISABLE KEYS */;
INSERT INTO `act_prod` (`createdAt`, `updatedAt`, `actId`, `prodId`) VALUES
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 1, 1),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 3, 1);
/*!40000 ALTER TABLE `act_prod` ENABLE KEYS */;

-- 傾印  資料表 membercard.admin_roles 結構
DROP TABLE IF EXISTS `admin_roles`;
CREATE TABLE IF NOT EXISTS `admin_roles` (
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  `roleId` int(11) NOT NULL,
  `adminId` int(11) NOT NULL,
  PRIMARY KEY (`roleId`,`adminId`),
  KEY `adminId` (`adminId`),
  CONSTRAINT `admin_roles_ibfk_1` FOREIGN KEY (`roleId`) REFERENCES `store_role` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `admin_roles_ibfk_2` FOREIGN KEY (`adminId`) REFERENCES `store_admin` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 正在傾印表格  membercard.admin_roles 的資料：~4 rows (近似值)
/*!40000 ALTER TABLE `admin_roles` DISABLE KEYS */;
INSERT INTO `admin_roles` (`createdAt`, `updatedAt`, `roleId`, `adminId`) VALUES
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 1, 1),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 2, 2),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 3, 2),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 3, 3);
/*!40000 ALTER TABLE `admin_roles` ENABLE KEYS */;

-- 傾印  資料表 membercard.admin_token 結構
DROP TABLE IF EXISTS `admin_token`;
CREATE TABLE IF NOT EXISTS `admin_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refreshToken` varchar(255) DEFAULT NULL COMMENT '更新令牌',
  `expiryDate` datetime DEFAULT NULL COMMENT '到期時間',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  `adminId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `adminId` (`adminId`),
  KEY `admin_token_refresh_token` (`refreshToken`),
  CONSTRAINT `admin_token_ibfk_1` FOREIGN KEY (`adminId`) REFERENCES `store_admin` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='店管更新令牌';

-- 正在傾印表格  membercard.admin_token 的資料：~0 rows (近似值)
/*!40000 ALTER TABLE `admin_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_token` ENABLE KEYS */;

-- 傾印  資料表 membercard.cart_item 結構
DROP TABLE IF EXISTS `cart_item`;
CREATE TABLE IF NOT EXISTS `cart_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ciProdSaleQty` decimal(10,2) DEFAULT NULL COMMENT '選購數量',
  `ciAddTime` datetime DEFAULT NULL COMMENT '加入購物車時間',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `memberId` int(11) DEFAULT NULL COMMENT 'FK_會員編號',
  `prodId` int(11) DEFAULT NULL COMMENT 'FK_商品編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `storeId` (`storeId`),
  KEY `memberId` (`memberId`),
  KEY `prodId` (`prodId`),
  CONSTRAINT `cart_item_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_item_ibfk_2` FOREIGN KEY (`memberId`) REFERENCES `member` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_item_ibfk_3` FOREIGN KEY (`prodId`) REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='購物車商品';

-- 正在傾印表格  membercard.cart_item 的資料：~2 rows (近似值)
/*!40000 ALTER TABLE `cart_item` DISABLE KEYS */;
INSERT INTO `cart_item` (`id`, `ciProdSaleQty`, `ciAddTime`, `storeId`, `memberId`, `prodId`, `createdAt`, `updatedAt`) VALUES
	(3, 2.00, '2021-10-04 19:12:50', 1, 1, 2, '2021-10-04 19:07:13', '2021-10-04 19:12:50'),
	(4, 1.00, '2021-10-04 19:13:07', 1, 1, 1, '2021-10-04 19:13:07', '2021-10-04 19:13:07');
/*!40000 ALTER TABLE `cart_item` ENABLE KEYS */;

-- 傾印  資料表 membercard.category 結構
DROP TABLE IF EXISTS `category`;
CREATE TABLE IF NOT EXISTS `category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cateCode` varchar(50) DEFAULT NULL COMMENT '類別代碼',
  `cateName` varchar(50) DEFAULT NULL COMMENT '類別名稱',
  `cateDesc` varchar(255) DEFAULT NULL COMMENT '類別備註',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_cate_code` (`cateCode`),
  KEY `storeId` (`storeId`),
  CONSTRAINT `category_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='商品類別';

-- 正在傾印表格  membercard.category 的資料：~3 rows (近似值)
/*!40000 ALTER TABLE `category` DISABLE KEYS */;
INSERT INTO `category` (`id`, `cateCode`, `cateName`, `cateDesc`, `storeId`, `createdAt`, `updatedAt`) VALUES
	(1, 'CATE1', '餅類', '餅類說明說明', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(2, 'CATE2', '飲料', '飲料說明說明', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, 'CATE3', '糖果', '糖果說明說明', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `category` ENABLE KEYS */;

-- 傾印  資料表 membercard.cate_prod 結構
DROP TABLE IF EXISTS `cate_prod`;
CREATE TABLE IF NOT EXISTS `cate_prod` (
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  `cateId` int(11) NOT NULL,
  `prodId` int(11) NOT NULL,
  PRIMARY KEY (`cateId`,`prodId`),
  KEY `prodId` (`prodId`),
  CONSTRAINT `cate_prod_ibfk_1` FOREIGN KEY (`cateId`) REFERENCES `category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cate_prod_ibfk_2` FOREIGN KEY (`prodId`) REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品類別';

-- 正在傾印表格  membercard.cate_prod 的資料：~6 rows (近似值)
/*!40000 ALTER TABLE `cate_prod` DISABLE KEYS */;
INSERT INTO `cate_prod` (`createdAt`, `updatedAt`, `cateId`, `prodId`) VALUES
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 1, 1),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 1, 2),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 2, 3),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 2, 4),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 3, 5),
	('2021-10-01 20:32:36', '2021-10-01 20:32:36', 3, 6);
/*!40000 ALTER TABLE `cate_prod` ENABLE KEYS */;

-- 傾印  資料表 membercard.coupon 結構
DROP TABLE IF EXISTS `coupon`;
CREATE TABLE IF NOT EXISTS `coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cpnCode` varchar(50) DEFAULT NULL COMMENT '優惠代碼',
  `cpnName` varchar(50) DEFAULT NULL COMMENT '優惠名稱',
  `cpnIntro` varchar(255) DEFAULT NULL COMMENT '優惠介紹',
  `cpnDesc` varchar(255) DEFAULT NULL COMMENT '優惠備註',
  `cpnImage` varchar(50) DEFAULT NULL COMMENT '優惠圖片',
  `cpnBigImage` varchar(255) DEFAULT NULL COMMENT '優惠大圖',
  `cpnStartTime` datetime DEFAULT NULL COMMENT '開始時間',
  `cpnStopTime` datetime DEFAULT NULL COMMENT '結束時間',
  `cpnStatus` varchar(20) DEFAULT NULL COMMENT '優惠狀態',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupon_cpn_code` (`cpnCode`),
  KEY `storeId` (`storeId`),
  CONSTRAINT `coupon_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='優惠項目';

-- 正在傾印表格  membercard.coupon 的資料：~3 rows (近似值)
/*!40000 ALTER TABLE `coupon` DISABLE KEYS */;
INSERT INTO `coupon` (`id`, `cpnCode`, `cpnName`, `cpnIntro`, `cpnDesc`, `cpnImage`, `cpnBigImage`, `cpnStartTime`, `cpnStopTime`, `cpnStatus`, `storeId`, `createdAt`, `updatedAt`) VALUES
	(1, '202101-01', '飲料買一送一券', '慶祝台灣+0,不限品項飲料買一送一', '飲料買一送一券備註備註', '00000001.png', '["00000001_b01.png"]', '2021-08-01 00:00:00', '2022-12-31 00:00:00', 'ENABLE_STORE', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(2, '202101-02', '月餅9折券', '慶祝中秋節,月餅一律9折', '月餅9折券備註備註', '00000002.png', '["00000002_b01.png"]', '2021-08-01 00:00:00', '2022-12-31 00:00:00', 'ENABLE_STORE', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, '202102-11', '個人獨享杯', '集點送飲料，集點卡集滿送獨享杯', '個人獨享杯備註備註', '00000011.png', '["00000011_b01.png"]', '2021-08-01 00:00:00', '2022-12-31 12:00:00', 'ENABLE_PERSON', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `coupon` ENABLE KEYS */;

-- 傾印  資料表 membercard.coupon_person 結構
DROP TABLE IF EXISTS `coupon_person`;
CREATE TABLE IF NOT EXISTS `coupon_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gotTime` datetime DEFAULT NULL COMMENT '取得時間',
  `gotMemo` varchar(255) DEFAULT NULL COMMENT '取得備註',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `memberId` int(11) DEFAULT NULL COMMENT 'FK_會員編號',
  `couponId` int(11) DEFAULT NULL COMMENT 'FK_優惠編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `storeId` (`storeId`),
  KEY `memberId` (`memberId`),
  KEY `couponId` (`couponId`),
  CONSTRAINT `coupon_person_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `coupon_person_ibfk_2` FOREIGN KEY (`memberId`) REFERENCES `member` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `coupon_person_ibfk_3` FOREIGN KEY (`couponId`) REFERENCES `coupon` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='個人優惠券';

-- 正在傾印表格  membercard.coupon_person 的資料：~1 rows (近似值)
/*!40000 ALTER TABLE `coupon_person` DISABLE KEYS */;
INSERT INTO `coupon_person` (`id`, `gotTime`, `gotMemo`, `storeId`, `memberId`, `couponId`, `createdAt`, `updatedAt`) VALUES
	(1, '2021-09-11 00:00:00', '取得記錄備註取得記錄備註', 1, 1, 3, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `coupon_person` ENABLE KEYS */;

-- 傾印  資料表 membercard.coupon_usage 結構
DROP TABLE IF EXISTS `coupon_usage`;
CREATE TABLE IF NOT EXISTS `coupon_usage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gotTime` datetime DEFAULT NULL COMMENT '取得時間',
  `gotMemo` varchar(255) DEFAULT NULL COMMENT '取得備註',
  `useTime` datetime DEFAULT NULL COMMENT '使用時間',
  `useMemo` varchar(255) DEFAULT NULL COMMENT '使用備註',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `memberId` int(11) DEFAULT NULL COMMENT 'FK_會員編號',
  `couponId` int(11) DEFAULT NULL COMMENT 'FK_優惠編號',
  `adminId` int(11) DEFAULT NULL COMMENT 'FK_店管編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `storeId` (`storeId`),
  KEY `memberId` (`memberId`),
  KEY `couponId` (`couponId`),
  KEY `adminId` (`adminId`),
  CONSTRAINT `coupon_usage_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `coupon_usage_ibfk_2` FOREIGN KEY (`memberId`) REFERENCES `member` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `coupon_usage_ibfk_3` FOREIGN KEY (`couponId`) REFERENCES `coupon` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `coupon_usage_ibfk_4` FOREIGN KEY (`adminId`) REFERENCES `store_admin` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='優惠券使用記錄';

-- 正在傾印表格  membercard.coupon_usage 的資料：~1 rows (近似值)
/*!40000 ALTER TABLE `coupon_usage` DISABLE KEYS */;
INSERT INTO `coupon_usage` (`id`, `gotTime`, `gotMemo`, `useTime`, `useMemo`, `storeId`, `memberId`, `couponId`, `adminId`, `createdAt`, `updatedAt`) VALUES
	(1, '2021-08-01 00:00:00', '取得記錄備註取得記錄備註', '2021-09-01 00:00:00', '使用記錄備註使用記錄備註', 1, 1, 1, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `coupon_usage` ENABLE KEYS */;

-- 傾印  資料表 membercard.device_token 結構
DROP TABLE IF EXISTS `device_token`;
CREATE TABLE IF NOT EXISTS `device_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `devOsType` varchar(1) DEFAULT NULL COMMENT '設備OS類型',
  `devUuid` varchar(50) DEFAULT NULL COMMENT '設備唯一識別碼',
  `devPushId` varchar(255) DEFAULT NULL COMMENT '設備推播代碼',
  `devVerifyCode` varchar(10) DEFAULT NULL COMMENT '驗證碼',
  `devVerifyStatus` varchar(20) DEFAULT NULL COMMENT '驗證狀態',
  `smsSendTime` datetime DEFAULT NULL COMMENT '發送時間',
  `smsConfirmTime` datetime DEFAULT NULL COMMENT '確認時間',
  `refreshToken` varchar(255) DEFAULT NULL COMMENT '更新令牌',
  `expiryDate` datetime DEFAULT NULL COMMENT '到期時間',
  `memberId` int(11) DEFAULT NULL COMMENT 'FK_會員編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `memberId` (`memberId`),
  KEY `device_token_dev_os_type_dev_uuid` (`devOsType`,`devUuid`),
  KEY `device_token_refresh_token` (`refreshToken`),
  CONSTRAINT `device_token_ibfk_1` FOREIGN KEY (`memberId`) REFERENCES `member` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='會員設備與令牌';

-- 正在傾印表格  membercard.device_token 的資料：~7 rows (近似值)
/*!40000 ALTER TABLE `device_token` DISABLE KEYS */;
INSERT INTO `device_token` (`id`, `devOsType`, `devUuid`, `devPushId`, `devVerifyCode`, `devVerifyStatus`, `smsSendTime`, `smsConfirmTime`, `refreshToken`, `expiryDate`, `memberId`, `createdAt`, `updatedAt`) VALUES
	(1, '3', 'c8cc911e-418d-4782-93fb-ad9278863f28', 'c8cc911e-418d-4782-93fb-ad9278863f28', '123456', 'VERIFIED', '2021-12-21 19:11:55', '2021-12-21 19:12:20', 'c8cc911e-418d-4782-93fb-ad9278863f28', '2022-01-20 19:13:30', 1, '2021-10-04 12:23:32', '2021-12-21 19:13:30'),
	(2, '3', 'LIFFAPP-SIGNATURE', 'LINE-USER-ID', '652670', 'VERIFIED', '2021-11-02 11:48:01', '2021-11-02 11:48:31', '09436fcc-3e3c-4684-ad4b-2bd0e4b8f94f', '2021-12-02 11:48:31', 4, '2021-10-27 15:49:56', '2021-11-02 11:48:31'),
	(3, '3', 'f50cf99b-3e3a-4a10-ba2c-4390459baf4a', 'f50cf99b-3e3a-4a10-ba2c-4390459baf4a', '123456', 'VERIFIED', '2021-12-01 15:28:22', '2021-12-01 20:54:19', 'f50cf99b-3e3a-4a10-ba2c-4390459baf4a', '2022-01-27 17:41:19', 1, '2021-12-01 11:51:25', '2021-12-28 17:41:19'),
	(4, '3', '93f17ed6-460f-4cb7-bf3b-2709b2213c0f', '93f17ed6-460f-4cb7-bf3b-2709b2213c0f', '123456', 'VERIFIED', '2021-12-21 19:14:40', '2021-12-21 19:15:06', '93f17ed6-460f-4cb7-bf3b-2709b2213c0f', '2022-01-20 19:15:06', 1, '2021-12-21 19:14:40', '2021-12-21 19:15:06'),
	(5, '3', '0dde10d9-8e6a-4bbe-a9f8-293ccee82f66', '0dde10d9-8e6a-4bbe-a9f8-293ccee82f66', '123456', 'VERIFIED', '2021-12-22 10:58:44', '2021-12-22 10:59:06', '0dde10d9-8e6a-4bbe-a9f8-293ccee82f66', '2022-01-21 10:59:06', 1, '2021-12-22 10:58:44', '2021-12-22 10:59:06'),
	(6, '3', '0ef9ac85-e878-4213-82bd-192dee4e372c', '0ef9ac85-e878-4213-82bd-192dee4e372c', '123456', 'VERIFIED', '2021-12-29 11:16:32', '2021-12-29 11:16:40', '0ef9ac85-e878-4213-82bd-192dee4e372c', '2022-02-02 17:09:37', 1, '2021-12-29 11:16:32', '2022-01-03 17:09:37'),
	(7, '3', 'b8b88c5a-3e66-4cc1-8508-efa5e05d86c9', 'b8b88c5a-3e66-4cc1-8508-efa5e05d86c9', '123456', 'VERIFIED', '2022-01-03 17:11:15', '2022-01-03 17:11:19', NULL, NULL, 1, '2022-01-03 17:11:15', '2022-02-09 17:29:13');
/*!40000 ALTER TABLE `device_token` ENABLE KEYS */;

-- 傾印  資料表 membercard.member 結構
DROP TABLE IF EXISTS `member`;
CREATE TABLE IF NOT EXISTS `member` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mbrMobile` varchar(20) DEFAULT NULL COMMENT '會員手機號碼',
  `mbrCode` varchar(50) DEFAULT NULL COMMENT '會員代碼(卡號)',
  `mbrNick` varchar(50) DEFAULT NULL COMMENT '會員暱稱',
  `mbrName` varchar(50) DEFAULT NULL COMMENT '會員姓名',
  `mbrBirth` varchar(20) DEFAULT NULL COMMENT '會員生日',
  `mbrGender` varchar(5) DEFAULT NULL COMMENT '會員性別',
  `mbrEmail` varchar(50) DEFAULT NULL COMMENT '電子郵件',
  `mbrAddr` varchar(50) DEFAULT NULL COMMENT '會員地址',
  `mbrAvatar` varchar(50) DEFAULT NULL COMMENT '會員頭像',
  `mbrEnabled` tinyint(1) DEFAULT NULL COMMENT '啟用狀態',
  `mbrEnabledTime` datetime DEFAULT NULL COMMENT '啟用時間',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `storeId` (`storeId`),
  KEY `member_mbr_mobile` (`mbrMobile`),
  KEY `member_mbr_code` (`mbrCode`),
  CONSTRAINT `member_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='會員使用者';

-- 正在傾印表格  membercard.member 的資料：~4 rows (近似值)
/*!40000 ALTER TABLE `member` DISABLE KEYS */;
INSERT INTO `member` (`id`, `mbrMobile`, `mbrCode`, `mbrNick`, `mbrName`, `mbrBirth`, `mbrGender`, `mbrEmail`, `mbrAddr`, `mbrAvatar`, `mbrEnabled`, `mbrEnabledTime`, `storeId`, `createdAt`, `updatedAt`) VALUES
	(1, '0911222333', '12342109013330', '會員333', 'ABC', NULL, NULL, '', NULL, NULL, 1, '2021-10-04 12:23:37', 1, '2021-10-01 20:32:36', '2021-12-29 11:55:38'),
	(2, '0911222444', '12342109014440', '會員444', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, '0911222555', '12342109015550', '會員555', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(4, '0952924280', '12342110272800', '會員280', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2021-10-27 15:50:09', 1, '2021-10-27 15:49:56', '2021-10-27 15:50:09');
/*!40000 ALTER TABLE `member` ENABLE KEYS */;

-- 傾印  資料表 membercard.order 結構
DROP TABLE IF EXISTS `order`;
CREATE TABLE IF NOT EXISTS `order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `paymentId` varchar(50) DEFAULT NULL COMMENT '付款編號',
  `paymentType` varchar(20) DEFAULT NULL COMMENT '付款方式',
  `paymentAmount` decimal(10,2) DEFAULT NULL COMMENT '付款總金額',
  `paymentTime` datetime DEFAULT NULL COMMENT '付款時間',
  `paymentStatus` varchar(20) DEFAULT NULL COMMENT '付款狀態',
  `paymentErrmsg` varchar(255) DEFAULT NULL COMMENT '支付失敗訊息',
  `orderAmount` decimal(10,2) DEFAULT NULL COMMENT '訂單總金額',
  `orderTime` datetime DEFAULT NULL COMMENT '訂單時間',
  `orderStatus` varchar(20) DEFAULT NULL COMMENT '訂單狀態',
  `orderMbrMemo` varchar(255) DEFAULT NULL COMMENT '會員備註',
  `orderStoreMemo` varchar(255) DEFAULT NULL COMMENT '店家備註',
  `deliverType` varchar(20) DEFAULT NULL COMMENT '配送方式',
  `deliverTime` datetime DEFAULT NULL COMMENT '配送時間',
  `deliverStatus` varchar(20) DEFAULT NULL COMMENT '配送狀態',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `memberId` int(11) DEFAULT NULL COMMENT 'FK_會員編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_payment_id` (`paymentId`),
  KEY `storeId` (`storeId`),
  KEY `memberId` (`memberId`),
  CONSTRAINT `order_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_ibfk_2` FOREIGN KEY (`memberId`) REFERENCES `member` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COMMENT='訂單';

-- 正在傾印表格  membercard.order 的資料：~43 rows (近似值)
/*!40000 ALTER TABLE `order` DISABLE KEYS */;
INSERT INTO `order` (`id`, `paymentId`, `paymentType`, `paymentAmount`, `paymentTime`, `paymentStatus`, `paymentErrmsg`, `orderAmount`, `orderTime`, `orderStatus`, `orderMbrMemo`, `orderStoreMemo`, `deliverType`, `deliverTime`, `deliverStatus`, `storeId`, `memberId`, `createdAt`, `updatedAt`) VALUES
	(1, 'ABCD123456', 'CART', 800.00, '2021-10-10 09:48:48', 'SUCCESS', '', 800.00, '2021-10-01 00:00:00', 'DONE', '會員備註', '店家備註', 'ONSITE', '2021-10-01 00:05:00', 'INIT', 1, 1, '2021-10-01 20:32:36', '2021-10-10 09:48:48'),
	(5, '2681B976-A1F8-4E72-B3CB-53C03F6BAE2B', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-11-09 17:41:11', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-11-09 17:41:11', '2021-11-09 17:41:11'),
	(6, 'ABCD123457', 'CART', 380.00, '2021-10-11 09:48:48', 'SUCCESS', '', 380.00, '2021-10-11 00:00:00', 'DONE', '會員備註', '店家備註', 'ONSITE', '2021-10-01 00:05:00', 'INIT', 1, 1, '2021-10-01 20:32:36', '2021-10-10 09:48:48'),
	(7, 'ABCD123458', 'CUSTOM', 200.00, '2021-10-12 09:48:48', 'IN_PROGRESS', '', 200.00, '2021-10-12 00:00:00', 'DONE', '會員備註', '店家備註', 'ONSITE', '2021-10-01 00:05:00', 'INIT', 1, 1, '2021-10-01 20:32:36', '2021-10-10 09:48:48'),
	(8, 'ABCD123459', 'CUSTOM', 1000.00, '2021-10-13 09:48:48', 'IN_PROGRESS', '', 1000.00, '2021-10-13 00:00:00', 'DONE', '會員備註', '店家備註', 'ONSITE', '2021-10-01 00:05:00', 'INIT', 1, 1, '2021-10-01 20:32:36', '2021-10-10 09:48:48'),
	(9, '3CF47A64-CC90-4C83-BC84-5A3A6D97A85C', 'CART', 80.00, NULL, 'IN_PROGRESS', '', 80.00, '2021-11-30 19:23:01', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-11-30 19:23:01', '2021-11-30 19:23:01'),
	(10, 'D78666CA-1819-4D47-824A-0AF3C8EFAC0C', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-11-30 19:26:58', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-11-30 19:26:58', '2021-11-30 19:26:58'),
	(12, '9B9CEEB7-B796-489E-A688-6742B0D906DB', 'CART', NULL, NULL, 'IN_PROGRESS', '', 340.00, '2021-11-30 20:05:30', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-11-30 20:05:30', '2021-11-30 20:05:30'),
	(13, '1E555288-6922-4011-B37F-F662C481C349', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 200.00, '2021-11-30 20:35:32', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-11-30 20:35:32', '2021-11-30 20:35:32'),
	(14, '4765206D-EAFB-4E6B-BCBE-449F6970D500', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-12-01 11:53:52', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-01 11:53:52', '2021-12-01 11:53:52'),
	(15, '224138B8-DD4F-4BDD-98CB-4E7154891A70', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80000.00, '2021-12-01 12:00:46', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-01 12:00:46', '2021-12-01 12:00:46'),
	(16, '2C556D40-E64C-4AC4-BB2D-83D957ECA599', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80000.00, '2021-12-01 12:04:15', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-01 12:04:15', '2021-12-01 12:04:15'),
	(17, '621D3617-00D1-4998-B397-17DAAFB4D8A3', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 10.00, '2021-12-01 15:03:43', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-01 15:03:43', '2021-12-01 15:03:43'),
	(18, 'D4F9324F-5780-4F22-A78A-8EB00D7A2E18', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-12-01 20:54:31', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-01 20:54:31', '2021-12-01 20:54:31'),
	(19, '4A26A4F3-2FD2-4BAF-8083-790EC83ECC57', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-01 21:00:26', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-01 21:00:26', '2021-12-01 21:00:26'),
	(20, '42F9C453-60D8-4B78-9916-7B97EBFEEB56', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-01 21:00:39', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-01 21:00:39', '2021-12-01 21:00:39'),
	(21, 'A342E9D8-57DD-4CCD-B2EA-23ED79FC771A', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-01 21:38:58', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-01 21:38:58', '2021-12-01 21:38:58'),
	(22, '5D80640C-939D-429A-BA50-A1F4D90A8380', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-08 16:30:00', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-08 16:30:00', '2021-12-08 16:30:00'),
	(23, '75E9CF63-0E6E-46DE-B9B1-B252A6FEB29C', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 120.00, '2021-12-08 16:36:00', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-08 16:36:00', '2021-12-08 16:36:00'),
	(24, '120E7042-9B9D-4C9D-A9F2-D11E4A012DBC', 'CART', NULL, NULL, 'IN_PROGRESS', '', 40.00, '2021-12-08 17:05:54', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-08 17:05:54', '2021-12-08 17:05:54'),
	(25, 'A2469124-F7DD-4BEB-ACC5-F292D42E862D', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-12-09 22:20:01', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-09 22:20:01', '2021-12-09 22:20:01'),
	(26, '22711E51-268C-4FEA-895E-B4172490B2DE', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-12-22 17:45:17', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-22 17:45:17', '2021-12-22 17:45:17'),
	(27, '3DDA3D3B-5D49-4A22-B97C-8E91CD1A037C', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-12-22 18:05:37', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-22 18:05:37', '2021-12-22 18:05:37'),
	(28, 'BA24479B-41CA-4A55-A150-B55ACBC0F7AE', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-28 17:41:21', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-28 17:41:21', '2021-12-28 17:41:21'),
	(29, 'D7021C50-AD11-4EF3-BC6B-C82EB5E31B49', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2021-12-28 17:41:44', 'UNDONE', '', '', '', NULL, '', 1, 1, '2021-12-28 17:41:44', '2021-12-28 17:41:44'),
	(30, 'BB76A118-8AA6-4847-9D5C-816723226748', 'CART', NULL, NULL, 'IN_PROGRESS', '', 40.00, '2021-12-28 17:42:07', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-28 17:42:07', '2021-12-28 17:42:07'),
	(31, 'EFB4FBC3-DBA1-41AB-8F8D-FDCC883E9F21', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-28 17:42:28', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-28 17:42:28', '2021-12-28 17:42:28'),
	(32, '6A924074-4BCB-43A5-B668-110B3644F02B', 'CART', NULL, NULL, 'IN_PROGRESS', '', 180.00, '2021-12-28 17:42:39', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-28 17:42:39', '2021-12-28 17:42:39'),
	(33, 'DB138D70-D575-44C8-A26C-3867CD2CD777', 'CART', NULL, NULL, 'IN_PROGRESS', '', 180.00, '2021-12-28 17:42:56', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-28 17:42:56', '2021-12-28 17:42:56'),
	(34, 'C010DF68-CEF2-49F6-BC26-C57061DF3E17', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-28 17:43:40', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-28 17:43:40', '2021-12-28 17:43:40'),
	(35, '4D3D9A43-DDCE-4B43-9F88-387EE3EC0E2E', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-29 11:17:49', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-29 11:17:49', '2021-12-29 11:17:49'),
	(36, '851EE291-6B20-483E-92B9-8B20EABCF38B', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2021-12-29 11:18:38', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-29 11:18:38', '2021-12-29 11:18:38'),
	(37, '83B0F1B0-727E-4017-81B4-A28F753DC3E8', 'CART', NULL, NULL, 'IN_PROGRESS', '', 180.00, '2021-12-29 11:19:25', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2021-12-29 11:19:25', '2021-12-29 11:19:25'),
	(38, '227C2A99-5AC4-4245-A7E5-C001C27670CA', 'CART', NULL, NULL, 'IN_PROGRESS', '', 180.00, '2022-01-03 16:36:44', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 16:36:44', '2022-01-03 16:36:44'),
	(39, '0DAE2136-060A-4458-8337-77D1AEA6AFFA', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2022-01-03 16:37:09', 'UNDONE', '', '', '', NULL, '', 1, 1, '2022-01-03 16:37:09', '2022-01-03 16:37:09'),
	(40, '14099ED0-807C-465D-9422-76E08C39EF1B', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2022-01-03 16:37:28', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 16:37:28', '2022-01-03 16:37:28'),
	(41, '0F1E9747-95BF-4E68-8928-1D4EB3F71188', 'CART', NULL, NULL, 'IN_PROGRESS', '', 40.00, '2022-01-03 16:42:30', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 16:42:30', '2022-01-03 16:42:30'),
	(42, '520B9123-9A87-433C-867E-DAE948058D51', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2022-01-03 16:43:12', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 16:43:12', '2022-01-03 16:43:12'),
	(43, 'C7EC50AD-80D6-499B-AFF4-E86FEBA11AB8', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2022-01-03 16:43:41', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 16:43:41', '2022-01-03 16:43:41'),
	(44, 'A83E1338-F25D-4E5D-B423-2D3A059C3454', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2022-01-03 16:55:52', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 16:55:52', '2022-01-03 16:55:52'),
	(45, 'BEC92FF9-EEDE-4737-8350-14464290E0D5', 'CART', NULL, NULL, 'IN_PROGRESS', '', 40.00, '2022-01-03 17:01:24', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 17:01:24', '2022-01-03 17:01:24'),
	(46, '99825D69-AECF-4215-87F0-36F1AFFBB868', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2022-01-03 17:01:41', 'UNDONE', '', '', '', NULL, '', 1, 1, '2022-01-03 17:01:41', '2022-01-03 17:01:41'),
	(47, 'E79A7841-8698-4F21-B67F-4EAC9492E7BF', 'CART', NULL, NULL, 'IN_PROGRESS', '', 180.00, '2022-01-03 17:10:07', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 17:10:07', '2022-01-03 17:10:07'),
	(48, '9921BE3B-6139-41F8-83FC-A3DA9C4EBF7B', 'CART', NULL, NULL, 'IN_PROGRESS', '', 180.00, '2022-01-03 17:11:26', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-03 17:11:26', '2022-01-03 17:11:26'),
	(49, 'DFC72301-94D4-4D71-8B77-A9B99506401B', 'CART', NULL, NULL, 'IN_PROGRESS', '', 80.00, '2022-01-05 09:53:13', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-05 09:53:13', '2022-01-05 09:53:13'),
	(50, '264A76F3-AD68-4FA0-99C3-1EC5536F1F32', 'CART', NULL, NULL, 'IN_PROGRESS', '', 40.00, '2022-01-05 12:28:22', 'UNDONE', '', '', '', NULL, 'INIT', 1, 1, '2022-01-05 12:28:22', '2022-01-05 12:28:22'),
	(51, '008F315E-3473-44C8-88BC-726CF82E7547', 'CUSTOM', NULL, NULL, 'IN_PROGRESS', '', 100.00, '2022-01-07 18:27:01', 'UNDONE', '', '', '', NULL, '', 1, 1, '2022-01-07 18:27:01', '2022-01-07 18:27:01');
/*!40000 ALTER TABLE `order` ENABLE KEYS */;

-- 傾印  資料表 membercard.order_item 結構
DROP TABLE IF EXISTS `order_item`;
CREATE TABLE IF NOT EXISTS `order_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oiProdCode` varchar(50) DEFAULT NULL COMMENT '結帳時商品代碼',
  `oiProdName` varchar(50) DEFAULT NULL COMMENT '結帳時商品名稱',
  `oiProdIntro` varchar(255) DEFAULT NULL COMMENT '結帳時商品介紹',
  `oiProdSalePrice` decimal(10,2) DEFAULT NULL COMMENT '結帳時商品售價',
  `oiProdSaleQty` decimal(10,2) DEFAULT NULL COMMENT '結帳時選購數量',
  `oiProdSpec` varchar(255) DEFAULT NULL COMMENT '結帳時商品規格',
  `oiProdDesc` varchar(255) DEFAULT NULL COMMENT '結帳時商品備註',
  `oiProdImage` varchar(50) DEFAULT NULL COMMENT '結帳時商品圖片',
  `oiProdBigImage` varchar(255) DEFAULT NULL COMMENT '結帳時商品大圖',
  `orderId` int(11) DEFAULT NULL COMMENT 'FK_訂單編號',
  `prodId` int(11) DEFAULT NULL COMMENT 'FK_原始商品編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `prodId` (`prodId`),
  CONSTRAINT `order_item_ibfk_1` FOREIGN KEY (`orderId`) REFERENCES `order` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_item_ibfk_2` FOREIGN KEY (`prodId`) REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COMMENT='訂單商品';

-- 正在傾印表格  membercard.order_item 的資料：~44 rows (近似值)
/*!40000 ALTER TABLE `order_item` DISABLE KEYS */;
INSERT INTO `order_item` (`id`, `oiProdCode`, `oiProdName`, `oiProdIntro`, `oiProdSalePrice`, `oiProdSaleQty`, `oiProdSpec`, `oiProdDesc`, `oiProdImage`, `oiProdBigImage`, `orderId`, `prodId`, `createdAt`, `updatedAt`) VALUES
	(1, 'A001', '月餅', '月餅月餅月餅', 80.00, 10.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 1, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(5, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 5, NULL, '2021-11-09 17:41:11', '2021-11-09 17:41:11'),
	(6, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 6, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(7, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 6, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(8, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', 40.00, 3.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 6, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(9, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 9, 1, '2021-11-30 19:23:01', '2021-11-30 19:23:01'),
	(10, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 10, 1, '2021-11-30 19:26:58', '2021-11-30 19:26:58'),
	(12, 'A001', '月餅', '月餅月餅月餅', 80.00, 2.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 12, 1, '2021-11-30 20:05:30', '2021-11-30 20:05:30'),
	(13, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 12, 2, '2021-11-30 20:05:30', '2021-11-30 20:05:30'),
	(14, '', '月餅111', '', 200.00, 1.00, '', '', '', '', 13, NULL, '2021-11-30 20:35:32', '2021-11-30 20:35:32'),
	(15, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 14, NULL, '2021-12-01 11:53:52', '2021-12-01 11:53:52'),
	(16, 'A001', '月餅', '月餅月餅月餅', 80.00, 1000.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 15, 1, '2021-12-01 12:00:46', '2021-12-01 12:00:46'),
	(17, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', 40.00, 2000.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 16, 3, '2021-12-01 12:04:15', '2021-12-01 12:04:15'),
	(18, '', '餐飲費', '', 10.00, 1.00, '', '', '', '', 17, NULL, '2021-12-01 15:03:43', '2021-12-01 15:03:43'),
	(19, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 18, NULL, '2021-12-01 20:54:31', '2021-12-01 20:54:31'),
	(20, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 19, 1, '2021-12-01 21:00:26', '2021-12-01 21:00:26'),
	(21, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 20, 1, '2021-12-01 21:00:39', '2021-12-01 21:00:39'),
	(22, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 21, 1, '2021-12-01 21:38:58', '2021-12-01 21:38:58'),
	(23, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 22, 1, '2021-12-08 16:30:00', '2021-12-08 16:30:00'),
	(24, '', '餐飲費', '', 120.00, 1.00, '', '', '', '', 23, NULL, '2021-12-08 16:36:00', '2021-12-08 16:36:00'),
	(25, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', 40.00, 1.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 24, 3, '2021-12-08 17:05:54', '2021-12-08 17:05:54'),
	(26, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 25, NULL, '2021-12-09 22:20:01', '2021-12-09 22:20:01'),
	(27, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 26, NULL, '2021-12-22 17:45:17', '2021-12-22 17:45:17'),
	(28, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 27, NULL, '2021-12-22 18:05:37', '2021-12-22 18:05:37'),
	(29, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 28, 1, '2021-12-28 17:41:21', '2021-12-28 17:41:21'),
	(30, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 29, NULL, '2021-12-28 17:41:44', '2021-12-28 17:41:44'),
	(31, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', 40.00, 1.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 30, 3, '2021-12-28 17:42:07', '2021-12-28 17:42:07'),
	(32, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 31, 1, '2021-12-28 17:42:28', '2021-12-28 17:42:28'),
	(33, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 32, 2, '2021-12-28 17:42:39', '2021-12-28 17:42:39'),
	(34, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 33, 2, '2021-12-28 17:42:56', '2021-12-28 17:42:56'),
	(35, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 34, 1, '2021-12-28 17:43:40', '2021-12-28 17:43:40'),
	(36, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 35, 1, '2021-12-29 11:17:49', '2021-12-29 11:17:49'),
	(37, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 36, 1, '2021-12-29 11:18:38', '2021-12-29 11:18:38'),
	(38, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 37, 2, '2021-12-29 11:19:25', '2021-12-29 11:19:25'),
	(39, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 38, 2, '2022-01-03 16:36:44', '2022-01-03 16:36:44'),
	(40, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 39, NULL, '2022-01-03 16:37:09', '2022-01-03 16:37:09'),
	(41, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 40, 1, '2022-01-03 16:37:28', '2022-01-03 16:37:28'),
	(42, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', 40.00, 1.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 41, 3, '2022-01-03 16:42:30', '2022-01-03 16:42:30'),
	(43, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 42, 1, '2022-01-03 16:43:12', '2022-01-03 16:43:12'),
	(44, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 43, 1, '2022-01-03 16:43:41', '2022-01-03 16:43:41'),
	(45, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 44, 1, '2022-01-03 16:55:52', '2022-01-03 16:55:52'),
	(46, 'A004', '咖啡', '咖啡咖啡咖啡咖啡', 40.00, 1.00, '咖啡規格規格', '咖啡說明說明', '00000004.png', '["00000004_b01.png","00000004_b02.png","00000004_b03.png"]', 45, 4, '2022-01-03 17:01:24', '2022-01-03 17:01:24'),
	(47, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 46, NULL, '2022-01-03 17:01:41', '2022-01-03 17:01:41'),
	(48, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 47, 2, '2022-01-03 17:10:07', '2022-01-03 17:10:07'),
	(49, 'A002', '古早餅', '古早餅古早餅古早餅', 180.00, 1.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 48, 2, '2022-01-03 17:11:26', '2022-01-03 17:11:26'),
	(50, 'A001', '月餅', '月餅月餅月餅', 80.00, 1.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 49, 1, '2022-01-05 09:53:13', '2022-01-05 09:53:13'),
	(51, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', 40.00, 1.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 50, 3, '2022-01-05 12:28:22', '2022-01-05 12:28:22'),
	(52, '', '餐飲費', '', 100.00, 1.00, '', '', '', '', 51, NULL, '2022-01-07 18:27:01', '2022-01-07 18:27:01');
/*!40000 ALTER TABLE `order_item` ENABLE KEYS */;

-- 傾印  資料表 membercard.pointcard 結構
DROP TABLE IF EXISTS `pointcard`;
CREATE TABLE IF NOT EXISTS `pointcard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pcCode` varchar(50) DEFAULT NULL COMMENT '集點卡代碼',
  `pcTitle` varchar(50) DEFAULT NULL COMMENT '集點卡標題',
  `pcSubTitle` varchar(255) DEFAULT NULL COMMENT '集點卡子標題',
  `pcDesc` text DEFAULT NULL COMMENT '集點卡備註',
  `pcStartTime` datetime DEFAULT NULL COMMENT '集點開始時間',
  `pcStopTime` datetime DEFAULT NULL COMMENT '集點結束時間',
  `pcMaxPoint` int(11) DEFAULT NULL COMMENT '一卡點數',
  `pcGotPoint` int(11) DEFAULT NULL COMMENT '掃1次幾點',
  `pcRepeatable` tinyint(1) DEFAULT NULL COMMENT '集滿可否重新收集',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `couponId` int(11) DEFAULT NULL COMMENT 'FK_優惠編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pointcard_pc_code` (`pcCode`),
  KEY `storeId` (`storeId`),
  KEY `couponId` (`couponId`),
  CONSTRAINT `pointcard_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pointcard_ibfk_2` FOREIGN KEY (`couponId`) REFERENCES `coupon` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='集點卡';

-- 正在傾印表格  membercard.pointcard 的資料：~1 rows (近似值)
/*!40000 ALTER TABLE `pointcard` DISABLE KEYS */;
INSERT INTO `pointcard` (`id`, `pcCode`, `pcTitle`, `pcSubTitle`, `pcDesc`, `pcStartTime`, `pcStopTime`, `pcMaxPoint`, `pcGotPoint`, `pcRepeatable`, `storeId`, `couponId`, `createdAt`, `updatedAt`) VALUES
	(1, '12345678-01', '夏日集點活動', '單次消費滿100元得1點，集滿10點可領取優惠券', '1.夏日集點活動(以下稱本活動)有效期限為2021年6月起至12月31日下午18:30止。\n2.單次消費滿100元，掃描店家提供之集點QRcode即可獲得1點。集滿10點可領取優惠券。\n3.集點卡與優惠券僅於厚厚咖啡會員APP使用，截圖無效。\n4.兌換商品以店家當日供應之狀況為準，如當日優惠商品售罄，店家將以等值商品做為兌換。\n5.本活動兌換商品恕不提供發票，亦不得與其他優惠合併使用。\n6.請留意您點數之有效期限，點數到期後，未兌換之點數將於隔日全數失效及歸零。\n7.厚厚咖啡保有解釋、隨時調整活動辦法、活動時間、優惠內容及終止活動之權利。', '2021-06-01 00:00:00', '2022-12-31 23:59:59', 10, 1, 1, 1, 3, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `pointcard` ENABLE KEYS */;

-- 傾印  資料表 membercard.pointcard_collect 結構
DROP TABLE IF EXISTS `pointcard_collect`;
CREATE TABLE IF NOT EXISTS `pointcard_collect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `collectNumber` int(11) DEFAULT NULL COMMENT '集點卡次數',
  `collectPoint` int(11) DEFAULT NULL COMMENT '本次累積點數',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `memberId` int(11) DEFAULT NULL COMMENT 'FK_會員編號',
  `pcId` int(11) DEFAULT NULL COMMENT 'FK_集點卡編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `storeId` (`storeId`),
  KEY `memberId` (`memberId`),
  KEY `pcId` (`pcId`),
  CONSTRAINT `pointcard_collect_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pointcard_collect_ibfk_2` FOREIGN KEY (`memberId`) REFERENCES `member` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pointcard_collect_ibfk_3` FOREIGN KEY (`pcId`) REFERENCES `pointcard` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='集點卡記錄';

-- 正在傾印表格  membercard.pointcard_collect 的資料：~0 rows (近似值)
/*!40000 ALTER TABLE `pointcard_collect` DISABLE KEYS */;
INSERT INTO `pointcard_collect` (`id`, `collectNumber`, `collectPoint`, `storeId`, `memberId`, `pcId`, `createdAt`, `updatedAt`) VALUES
	(1, 1, 2, 1, 1, 1, '2021-12-01 12:14:49', '2021-12-08 16:29:02');
/*!40000 ALTER TABLE `pointcard_collect` ENABLE KEYS */;

-- 傾印  資料表 membercard.point_collect 結構
DROP TABLE IF EXISTS `point_collect`;
CREATE TABLE IF NOT EXISTS `point_collect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `collectNumber` int(11) DEFAULT NULL COMMENT '集點卡次數',
  `gotPoint` int(11) DEFAULT NULL COMMENT '收集點數',
  `gotTime` datetime DEFAULT NULL COMMENT '收集時間',
  `gotMemo` varchar(255) DEFAULT NULL COMMENT '收集備註',
  `pccId` int(11) DEFAULT NULL COMMENT 'FK_集點卡記錄編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pccId` (`pccId`),
  KEY `point_collect_collect_number` (`collectNumber`),
  CONSTRAINT `point_collect_ibfk_1` FOREIGN KEY (`pccId`) REFERENCES `pointcard_collect` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='集點記錄';

-- 正在傾印表格  membercard.point_collect 的資料：~2 rows (近似值)
/*!40000 ALTER TABLE `point_collect` DISABLE KEYS */;
INSERT INTO `point_collect` (`id`, `collectNumber`, `gotPoint`, `gotTime`, `gotMemo`, `pccId`, `createdAt`, `updatedAt`) VALUES
	(1, 1, 1, '2021-12-01 12:14:49', '', 1, '2021-12-01 12:14:49', '2021-12-01 12:14:49'),
	(2, 1, 1, '2021-12-08 16:29:02', '', 1, '2021-12-08 16:29:02', '2021-12-08 16:29:02');
/*!40000 ALTER TABLE `point_collect` ENABLE KEYS */;

-- 傾印  資料表 membercard.product 結構
DROP TABLE IF EXISTS `product`;
CREATE TABLE IF NOT EXISTS `product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prodCode` varchar(50) DEFAULT NULL COMMENT '商品代碼',
  `prodName` varchar(50) DEFAULT NULL COMMENT '商品名稱',
  `prodIntro` varchar(255) DEFAULT NULL COMMENT '商品介紹',
  `prodTag` varchar(50) DEFAULT NULL COMMENT '商品標籤',
  `prodListPrice` decimal(10,2) DEFAULT NULL COMMENT '商品定價',
  `prodSalePrice` decimal(10,2) DEFAULT NULL COMMENT '商品售價',
  `prodQty` decimal(10,2) DEFAULT NULL COMMENT '商品庫存量',
  `prodSpec` varchar(255) DEFAULT NULL COMMENT '商品規格',
  `prodDesc` varchar(255) DEFAULT NULL COMMENT '商品備註',
  `prodImage` varchar(50) DEFAULT NULL COMMENT '商品圖片',
  `prodBigImage` varchar(255) DEFAULT NULL COMMENT '商品大圖',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_prod_code` (`prodCode`),
  KEY `storeId` (`storeId`),
  CONSTRAINT `product_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='商品列表';

-- 正在傾印表格  membercard.product 的資料：~6 rows (近似值)
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
INSERT INTO `product` (`id`, `prodCode`, `prodName`, `prodIntro`, `prodTag`, `prodListPrice`, `prodSalePrice`, `prodQty`, `prodSpec`, `prodDesc`, `prodImage`, `prodBigImage`, `storeId`, `createdAt`, `updatedAt`) VALUES
	(1, 'A001', '月餅', '月餅月餅月餅', NULL, 100.00, 80.00, 1000.00, '月餅規格規格', '月餅說明說明', '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png"]', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(2, 'A002', '古早餅', '古早餅古早餅古早餅', NULL, 200.00, 180.00, 200.00, '古早餅規格規格', '古早餅說明說明', '00000002.png', '["00000002_b01.png","00000002_b02.png","00000002_b03.png"]', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, 'A003', '珍珠奶茶', '珍珠奶茶珍珠奶茶珍珠奶茶', NULL, 50.00, 40.00, 2000.00, '珍珠奶茶規格規格', '珍珠奶茶說明說明', '00000003.png', '["00000003_b01.png","00000003_b02.png","00000003_b03.png"]', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(4, 'A004', '咖啡', '咖啡咖啡咖啡咖啡', NULL, 50.00, 40.00, 2000.00, '咖啡規格規格', '咖啡說明說明', '00000004.png', '["00000004_b01.png","00000004_b02.png","00000004_b03.png"]', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(5, 'A005', '巧克力豆', '巧克力豆', NULL, 80.00, 64.00, 10000.00, '巧克力豆規格規格', '巧克力豆說明說明', '00000005.png', '["00000005_b01.png","00000005_b02.png","00000005_b03.png"]', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(6, 'A006', '薄荷糖', '薄荷糖', NULL, 20.00, 15.00, 50000.00, '薄荷糖規格規格', '薄荷糖說明說明', '00000006.png', '["00000006_b01.png","00000006_b02.png","00000006_b03.png"]', 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `product` ENABLE KEYS */;

-- 傾印  資料表 membercard.store 結構
DROP TABLE IF EXISTS `store`;
CREATE TABLE IF NOT EXISTS `store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `storeCode` varchar(50) DEFAULT NULL COMMENT '店家代碼',
  `storeName` varchar(50) DEFAULT NULL COMMENT '店家名稱',
  `storePhone` varchar(50) DEFAULT NULL COMMENT '營業電話',
  `storeAddr` varchar(100) DEFAULT NULL COMMENT '營業地址',
  `storeAddrLat` decimal(11,8) DEFAULT NULL COMMENT '地址緯度',
  `storeAddrLng` decimal(11,8) DEFAULT NULL COMMENT '地址經度',
  `storeLogo` varchar(50) DEFAULT NULL COMMENT '店家Logo',
  `storeIntro` varchar(255) DEFAULT NULL COMMENT '店家介紹',
  `storeService` varchar(100) DEFAULT NULL COMMENT '服務項目',
  `storePlace` varchar(100) DEFAULT NULL COMMENT '場地服務',
  `storeReserve` varchar(100) DEFAULT NULL COMMENT '預約服務',
  `storeEnabled` tinyint(1) DEFAULT NULL COMMENT '啟用狀態',
  `storeImage` varchar(50) DEFAULT NULL COMMENT '店家圖片',
  `storeBigImage` varchar(255) DEFAULT NULL COMMENT '店家大圖',
  `storeWebsite` varchar(100) DEFAULT NULL COMMENT '店家官網',
  `storeLineoa` varchar(100) DEFAULT NULL COMMENT '店家Line@',
  `storeFacebook` varchar(100) DEFAULT NULL COMMENT '店家FB',
  `storeProdName` varchar(50) DEFAULT NULL COMMENT '通用商品名稱',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `store_store_code` (`storeCode`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='店家';

-- 正在傾印表格  membercard.store 的資料：~2 rows (近似值)
/*!40000 ALTER TABLE `store` DISABLE KEYS */;
INSERT INTO `store` (`id`, `storeCode`, `storeName`, `storePhone`, `storeAddr`, `storeAddrLat`, `storeAddrLng`, `storeLogo`, `storeIntro`, `storeService`, `storePlace`, `storeReserve`, `storeEnabled`, `storeImage`, `storeBigImage`, `storeWebsite`, `storeLineoa`, `storeFacebook`, `storeProdName`, `createdAt`, `updatedAt`) VALUES
	(1, '12345678', '店家名稱1', '02-12345678', '台北市松山區復興北路191號10樓之2', 25.04750522, 121.51710256, '', '店家介紹介紹介紹', '店家服務項目服務項目', '店家場地服務場地服務', '店家預約方式預約方式', 1, '00000001.png', '["00000001_b01.png","00000001_b02.png","00000001_b03.png","00000001_b04.png","00000001_b05.png"]', 'https://www.google.com.tw', 'https://lin.ee/Un9hZkk', 'https://www.facebook.com/koding.3plus1', '餐飲費', '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
/*!40000 ALTER TABLE `store` ENABLE KEYS */;

-- 傾印  資料表 membercard.store_admin 結構
DROP TABLE IF EXISTS `store_admin`;
CREATE TABLE IF NOT EXISTS `store_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adminAccount` varchar(50) DEFAULT NULL COMMENT '店管帳號',
  `adminPasswd` varchar(255) DEFAULT NULL COMMENT '店管密碼',
  `adminName` varchar(50) DEFAULT NULL COMMENT '店管名稱',
  `adminEmail` varchar(50) DEFAULT NULL COMMENT '店管郵件',
  `adminEnabled` tinyint(1) DEFAULT NULL COMMENT '啟用狀態',
  `storeId` int(11) DEFAULT NULL COMMENT 'FK_店家編號',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `storeId` (`storeId`),
  KEY `store_admin_admin_account` (`adminAccount`),
  CONSTRAINT `store_admin_ibfk_1` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='店家管理者';

-- 正在傾印表格  membercard.store_admin 的資料：~3 rows (近似值)
/*!40000 ALTER TABLE `store_admin` DISABLE KEYS */;
INSERT INTO `store_admin` (`id`, `adminAccount`, `adminPasswd`, `adminName`, `adminEmail`, `adminEnabled`, `storeId`, `createdAt`, `updatedAt`) VALUES
	(1, 'admin', '$2a$08$F2s1pAAxbbmdcGQS.t2MEuyFsvM3j.vn4DGIeG1FFqs3wHnfA0HtO', 'adminName', 'adminEmail', 1, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(2, 'mod', '$2a$08$OYTvw46K.x9wM5JdlciXkeqkRVWgfH9VBHl0jY1f/AdS3kyoG8nP2', 'modName', 'modEmail', 1, 1, '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, 'user', '$2a$08$VR6UMkUIFkcZqhnKywSUOOkBQ3eCasMQGc6txRPuoXWMUAiq/JqZK', 'userName', 'userEmail', 1, 2, '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `store_admin` ENABLE KEYS */;

-- 傾印  資料表 membercard.store_role 結構
DROP TABLE IF EXISTS `store_role`;
CREATE TABLE IF NOT EXISTS `store_role` (
  `id` int(11) NOT NULL,
  `roleCode` varchar(50) DEFAULT NULL,
  `roleName` varchar(50) DEFAULT NULL,
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 正在傾印表格  membercard.store_role 的資料：~2 rows (近似值)
/*!40000 ALTER TABLE `store_role` DISABLE KEYS */;
INSERT INTO `store_role` (`id`, `roleCode`, `roleName`, `createdAt`, `updatedAt`) VALUES
	(1, 'admin', '管理者', '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(2, 'moderator', '店長', '2021-10-01 20:32:36', '2021-10-01 20:32:36'),
	(3, 'user', '店員', '2021-10-01 20:32:36', '2021-10-01 20:32:36');
/*!40000 ALTER TABLE `store_role` ENABLE KEYS */;

-- 傾印  資料表 membercard.sttype 結構
DROP TABLE IF EXISTS `sttype`;
CREATE TABLE IF NOT EXISTS `sttype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sttCode` varchar(50) DEFAULT NULL COMMENT '類別代碼',
  `sttName` varchar(50) DEFAULT NULL COMMENT '類別名稱',
  `sttDesc` varchar(255) DEFAULT NULL COMMENT '類別備註',
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sttype_stt_code` (`sttCode`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='店家類別';

-- 正在傾印表格  membercard.sttype 的資料：~3 rows (近似值)
/*!40000 ALTER TABLE `sttype` DISABLE KEYS */;
INSERT INTO `sttype` (`id`, `sttCode`, `sttName`, `sttDesc`, `createdAt`, `updatedAt`) VALUES
	(1, 'TYPE1', '美食禮盒類', '美食禮盒類說明', '2022-01-27 18:01:14', '2022-01-27 18:01:14'),
	(2, 'TYPE2', '3C商品類', '3C商品類說明', '2022-01-27 18:01:14', '2022-01-27 18:01:14'),
	(3, 'TYPE3', '衣著穿戴類', '衣著穿戴類說明', '2022-01-27 18:01:14', '2022-01-27 18:01:14');
/*!40000 ALTER TABLE `sttype` ENABLE KEYS */;

-- 傾印  資料表 membercard.type_store 結構
DROP TABLE IF EXISTS `type_store`;
CREATE TABLE IF NOT EXISTS `type_store` (
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  `typeId` int(11) NOT NULL,
  `storeId` int(11) NOT NULL,
  PRIMARY KEY (`typeId`,`storeId`),
  KEY `storeId` (`storeId`),
  CONSTRAINT `type_store_ibfk_1` FOREIGN KEY (`typeId`) REFERENCES `sttype` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `type_store_ibfk_2` FOREIGN KEY (`storeId`) REFERENCES `store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='店家類別';

-- 正在傾印表格  membercard.type_store 的資料：~3 rows (近似值)
/*!40000 ALTER TABLE `type_store` DISABLE KEYS */;
INSERT INTO `type_store` (`createdAt`, `updatedAt`, `typeId`, `storeId`) VALUES
	('2022-01-27 18:01:14', '2022-01-27 18:01:14', 1, 1),
	('2022-01-27 18:01:14', '2022-01-27 18:01:14', 2, 1),
	('2022-01-27 18:01:14', '2022-01-27 18:01:14', 3, 1);
/*!40000 ALTER TABLE `type_store` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
